import org.eclipse.swt.*;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.*;

public class ComboSnippet {

	// static int count = 0;

	static class TextPrompter extends Dialog {

		String message = "";
		String result = null;
		Shell dialog;
		Text text;

		protected void checkSubclass() {
		}

		public void setInput(String input) {
			result = input;
		}

		public TextPrompter(Shell parent, int style) {
			super(parent, style);
		}

		public TextPrompter(Shell parent) {
			this(parent, SWT.APPLICATION_MODAL);
		}

		public String getMessage() {
			return message;
		}

		public void setMessage(String string) {
			message = string;
		}

		public String open() {
			dialog = new Shell(getParent(), getStyle());
			dialog.setText(getText());
			dialog.setLayout(new GridLayout());
			Label label = new Label(dialog, SWT.NONE);
			label.setText(message);
			label.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
			text = new Text(dialog, SWT.SINGLE | SWT.BORDER);
			GridData data = new GridData(GridData.FILL_HORIZONTAL);
			data.widthHint = 300;
			text.setLayoutData(data);
			if (result != null) {
				text.setText(result);
			}
			Composite buttons = new Composite(dialog, SWT.NONE);
			GridLayout grid = new GridLayout();
			grid.numColumns = 2;
			buttons.setLayout(grid);
			buttons.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_END));
			Button ok = new Button(buttons, SWT.PUSH);
			ok.setText("OK");
			data = new GridData();
			data.widthHint = 75;
			ok.setLayoutData(data);
			ok.addSelectionListener(new SelectionAdapter() {

				public void widgetSelected(SelectionEvent e) {
					result = text.getText();
					dialog.dispose();
				}
			});
			Button cancel = new Button(buttons, SWT.PUSH);
			cancel.setText("Cancel");
			data = new GridData();
			data.widthHint = 75;
			cancel.setLayoutData(data);
			cancel.addSelectionListener(new SelectionAdapter() {

				public void widgetSelected(SelectionEvent e) {
					dialog.dispose();
				}
			});
			dialog.setDefaultButton(ok);
			dialog.pack();
			dialog.open();
			while (!dialog.isDisposed()) {
				if (!dialog.getDisplay().readAndDispatch())
					dialog.getDisplay().sleep();
			}

			return result;
		}
	}

	public static void main(String[] args) {
		Display display = new Display();
		final Shell shell = new Shell(display);
		shell.setLayout(new GridLayout());

		ValueCombo.ISelection valueSelection = new ValueCombo.ISelection() {

			public String[] doSelection(String input) {
				// TODO Auto-generated method stub
				String retValue = input;
				TextPrompter dialog = new TextPrompter(shell);
				dialog.setInput(input);
				retValue = dialog.open();
				return new String[] { retValue };
			}
		};

		ValueCombo combo = new ValueCombo(shell, SWT.BORDER);
		combo.setItems(new String[] { "A", "B", "C" });
		for (int i = 0; i < combo.getItemCount() - 1; i++) {
			combo.addSelectionListener(i, valueSelection);
		}
		combo.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));

		CCombo combo2 = new CCombo(shell, SWT.BORDER);
		combo2.setItems(new String[] { "combo2", "B", "C" });
		combo2.setSelEvent(true);
		combo2.addSelectionListener(new SelectionListener() {

			public void widgetDefaultSelected(SelectionEvent e) {
				// TODO Auto-generated method stub

			}

			public void widgetSelected(SelectionEvent e) {
				// TODO Auto-generated method stub
				CCombo widget = (CCombo) e.widget;
				String retValue = widget.getText();
				int index = widget.getSelectionIndex();
				if(index == 2)
				{
					widget.setText(widget.getItem(index));
					return;
				}
				TextPrompter dialog = new TextPrompter(shell);
				dialog.setInput(retValue);
				retValue = dialog.open();
				
				if(retValue != null)
				{
					widget.setText(retValue);
				}
				
			}
		});
		combo2.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		combo2.setSize(200, 40);

		shell.pack();
		shell.open();
		while (!shell.isDisposed()) {
			if (!display.readAndDispatch())
				display.sleep();
		}

		display.dispose();
	}

}